﻿var LOGS_PER_PAGE = 20;

var ALARM_URGENT = 1;
var ALARM_MAJOR = 2;
var ALARM_MINOR = 3;
var ALARM_INFO = 4;

var language;

function mouseOverLog(obj)
{
	if(obj.disabled == false)
	{
		obj.style.background = "url(../images/btn5_hover.png)";
	}
}
function mouseOutLog(obj)
{
	if(obj.disabled == false)
	{
		obj.style.background = "url(../images/btn5_normal.png)";
	}
}

function updateStatus()
{
	sessPageNum = parseInt(document.getElementById("currPageNum").value);
	sessTotPage = parseInt(document.getElementById("sessTotPages").value);
	if (sessTotPage <= sessPageNum)
	{
		if(language == 0)
		{
			str = "Displaying page " + sessTotPage + " of " + sessTotPage;
		}
		else
		{
			str = "第" + sessTotPage + "页，共" + sessTotPage + "页";
		}
	}
	else
	{
		if(language == 0)
		{
			str = "Displaying page " + sessPageNum + " of " + sessTotPage;
		}
		else
		{
			str = "第" + sessPageNum + "页，共" + sessTotPage + "页";
		}
	}
	
	document.getElementById("statusField").innerHTML = str;
}

function disableControls(flag)
{
	disabledButton(document.getElementById("prev"), flag);
	disabledButton(document.getElementById("next"), flag);
	disabledButton(document.getElementById("last"), flag);
}

/*
	This function dynamically updates the given table with given data. 
	If the data is less than the number of rows, remaining rows will be hidden.
	PARAMS:
	1. tableName -> Name of the table to be updated.
	2. numOfHeaderRows -> Number of the header rows which are not MODIFIED during update operation.
	3. pageData -> Data to be updated to TDs
	4. colSep -> Delemiter which separates the data between each cell within the same row.
	5. rowSep -> Delemiter which is used to separate each row.
*/
function updateRows(tableName, numOfHeaderRows, pageData, colSep, rowSep)
{
	var targetTable = document.getElementById(tableName);
	var rowsCount = parseInt(targetTable.rows.length, 10) - numOfHeaderRows;
	var row;
	var child;
	var j;

	var rowData = pageData.split(rowSep);
	var dataAvailRows = rowData.length;

//	alert("rowsCount="+rowsCount);
	for(var i = 0; i < rowsCount; i++)
	{
		row = targetTable.rows[i + numOfHeaderRows];
		child = row.firstChild;

		j = 0;
		
		if(i < dataAvailRows)
		{
			var colData = rowData[i].split(colSep);

			while(child != null)
			{
			// This if condition is must. This will filter only TD elements from the html text where table is defined.
				if(child.nodeType == 1) 
				{
					if(j == 1)
					{
						switch(parseInt(colData[j]))
						{
							case ALARM_URGENT:
							{
								if(language == 0)
								{
									child.innerHTML = "Urgency";
								}
								else
								{
									child.innerHTML = "紧急告警";
								}
								break;
							}
							case ALARM_MAJOR:
							{
								if(language == 0)
								{
									child.innerHTML = "Major";
								}
								else
								{
									child.innerHTML = "主要告警";
								}
								break;
							}
							case ALARM_MINOR:
							{
								if(language == 0)
								{
									child.innerHTML = "Minor";
								}
								else
								{
									child.innerHTML = "次要告警";
								}
								break;
							}
							case ALARM_INFO:
							{
								if(language == 0)
								{
									child.innerHTML = "Info";
								}
								else
								{
									child.innerHTML = "提示告警";
								}
								break;
							}
							default:
							{
								break;
							}
						}
					}
					else
					{
						child.innerHTML = colData[j];
					}
					child.style.display = "";
					j++;
				}
				child = child.nextSibling;
			}
		}
		else
		{
			while(child!= null)
			{
			// This if condition is must. This will filter only TD elements from the html text where table is defined.
				if(child.nodeType == 1) 
				{
					child.style.display = "none";
					j++;
				}
				child = child.nextSibling;
			}			
		}
		
	}
}

/*
This function hides all the rows in the given table except the table header.
Number of header rows which should not be given through numOfHeaderRows variable.
*/
function hideRows(tableName, numOfHeaderRows)
{
	var targetTable = document.getElementById(tableName);
	var rowsCount = parseInt(targetTable.rows.length, 10) - numOfHeaderRows;
	var row;
	var child;
	var j;

	for (var i = 0; i < rowsCount; i++)
	{
		row = targetTable.rows[i+1];
		child = row.firstChild;

			while (child!= null)
			{
			// This if condition is must. This will filter only TD elements from the html text where table is defined.
				if (child.nodeType == 1) 
				{
					child.style.display = "none";
					j++;
				}
				child = child.nextSibling;
			}			
	}
}

function clearLogs()
{
	hideRows("tableReadLog", 1);
	document.getElementById("currPageNum").value = "1";//当前页数
	document.getElementById("sessTotPages").value = "0";//总页数
	updateStatus();
}

function postProcessRequest(responseArr, params)
{
	// if some error when getting pages
	if(responseArr[1] == "0") 
	{
		clearLogs();
		alert(responseArr[0]);
		return;
	}
	
	if((params=="FIRST") || (params=="LAST"))
	{
		document.getElementById("sessTotPages").value = responseArr[1];
		if(responseArr[1] == "1")
		{
			disableControls(true);
		}
		else
		{
			disableControls(false);
		}
		if(params=="LAST")
		{
			document.getElementById("currPageNum").value = responseArr[1];
			disabledButton(document.getElementById("next"), true);
		}
		else
		{
			disabledButton(document.getElementById("prev"), true);
		}
	}
	else if((params=="PREV") || (params=="NEXT"))
	{
		if(document.getElementById("currPageNum").value == "1")
		{
			disabledButton(document.getElementById("prev"), true);
		}
		else
		{
			disabledButton(document.getElementById("prev"), false);
		}
		
		if(document.getElementById("currPageNum").value == document.getElementById("sessTotPages").value)
		{
			disabledButton(document.getElementById("next"), true);
		}
		else
		{
			disabledButton(document.getElementById("next"), false);
		}
	}

	updateRows("tableReadLog", 1, responseArr[0], ',' , '&');

	updateStatus();
}


function submitQuery(params)
{
	var response;
	var xmlhttp = getHTTPObject();
	
	queryString = "type=23&cmd=1" +
		"&startTime=" +
		"&endTime=" +
		"&logType=1" + 
		"&currPageNum=" + document.getElementById("currPageNum").value +
		"&mode=" + params +
		"&language=" + language;


	xmlhttp.open("POST", "/goform/formIPQAM", true);
	if((bd.browser != "IE") && (language == 1))
	{
		xmlhttp.overrideMimeType("text/html;charset=gb2312");
	}
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", queryString.length);

	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			if((bd.browser == "IE") && (language == 1))
			{
				response = gb2utf8(xmlhttp.responseBody);
				var index = response.indexOf("</html>");
				var bias = response.length - index;
				response = response.slice(7, - bias);
			}
			else
			{
				response = xmlhttp.responseText.slice(7, -8);
			}
			var responseArr = response.split("||");

			postProcessRequest(responseArr, params);			
		}
	}

	xmlhttp.send(queryString);

	return true;
}

function getFirstSet()
{
	document.getElementById("currPageNum").value = "1";		
	submitQuery("FIRST");
}



/*This function */
function getPrevSet()
{
	var currPageNum = parseInt(document.getElementById("currPageNum").value);
	
	if(currPageNum > 1)
	{
		currPageNum--;
		document.getElementById("currPageNum").value = currPageNum;
		submitQuery("PREV");
	}
}

function getNextSet()
{
	var currPageNum = parseInt(document.getElementById("currPageNum").value);
	var sessTotPages = parseInt(document.getElementById("sessTotPages").value);
	

	if(currPageNum < sessTotPages)
	{
		currPageNum++;
		document.getElementById("currPageNum").value = currPageNum;
		if(currPageNum == sessTotPages)
		{
			// care should be taken in backend if logs are overwritten within the session
		}
		submitQuery("NEXT");
	}
}

function getLastSet()
{
	submitQuery("LAST");
}

window.onload = function()
{
	language = document.getElementById("language").value;
	getFirstSet();	
}
